/** @file   wingedai.h
 * @brief   Declarations of WingedAI class
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_WINGEDAI_H
#define H_WWW_WINGEDAI_H

#include "aicontroller.h"


namespace WeWantWar {

/** @class  WingedAI
 * @brief   The logic that controls the Winged Aliens.
 * @author  Tomi Lamminsaari
 *
 * @par Behaviour of Winged Alien
 * When the Winged Alien does not see the player, they fly randomly around the
 * game level.
 * @par
 * When they get player in sight they start the attack phase. This means that
 * they fly towards the player and shoot him when they get close enough.
 * After they've shot player they start the evading phase when they try
 * to go away from player. As they get far enough they reattack.
 *
 */
class WingedAI : public AIController
{
public:

  ///
  /// Static members
  /// ==============
  
  /** The distance from target when we start new attack */
  static const float REATTACK_DISTANCE;
  /** The distance from target when we shoot */
  static const float ATTACK_DISTANCE;
  


  ///
  /// Constructor, destructor
  /// =======================
  
  /** Constructor.
   * @param     pAlien            Pointer to GameObject we're controlling.
   */
  WingedAI( GameObject* pAlien );
  
  /** Destructor.
   */
  virtual ~WingedAI();
  
  
  
  ///
  /// Methods
  /// =======
  
  /** Updates the controller-settings for winged alien.
   */
  virtual void updateAI( bool seeTarget, float dist );
  
  
  
protected:
  
  ///
  /// Members
  /// =======
  
  /** Tells are we in evading-mode or not. */
  bool  m_evading;
  /** Counter we need to stop evading. */
  int   m_evadeCounter;
  
  
private:
  /** Disabled copy constructor.
   */
  WingedAI( const WingedAI& rO );
  
  /** Disabled assignment operator.
   */
  WingedAI& operator = ( const WingedAI& rO );
};

};  // end of namespace

#endif // WINGEDAI_H

/** Changes log
 *
 * @Log$
 */
 
